<?php
require_once '../../includes/db.php';
$message = '';

// Handle Add Role
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_role'])) {
    $role_name = trim($_POST['role_name']);

    if (!empty($role_name)) {
        $stmt = $pdo->prepare("INSERT INTO roles (name) VALUES (?)");
        if ($stmt->execute([$role_name])) {
            $message = "<div class='alert alert-success'>Role added successfully.</div>";
        } else {
            $message = "<div class='alert alert-danger'>Error adding role.</div>";
        }
    } else {
        $message = "<div class='alert alert-warning'>Role name cannot be empty.</div>";
    }
}

// Handle Delete Role
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM roles WHERE id = ?");
    if ($stmt->execute([$id])) {
        $message = "<div class='alert alert-success'>Role deleted successfully.</div>";
    }
}

// Handle Update Role
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_role'])) {
    $id = (int)$_POST['role_id'];
    $updated_name = trim($_POST['updated_name']);
    if (!empty($updated_name)) {
        $stmt = $pdo->prepare("UPDATE roles SET name = ? WHERE id = ?");
        if ($stmt->execute([$updated_name, $id])) {
            $message = "<div class='alert alert-success'>Role updated successfully.</div>";
        }
    }
}

$roles = $pdo->query("SELECT * FROM roles ORDER BY id DESC")->fetchAll();
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Add Role</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #f1f3f7;
    }
    .content {
      max-width: 700px;
      margin: auto;
      padding: 30px;
    }
  </style>
</head>
<body>
<?php include 'navbar.php'; ?>
<div class="content">
  <h2 class="mb-4">Add Role</h2>
  <?= $message ?>

  <form method="POST" class="bg-white p-4 rounded shadow-sm mb-4">
    <div class="mb-3">
      <label for="role_name" class="form-label">Role Name</label>
      <input type="text" name="role_name" id="role_name" class="form-control" placeholder="e.g., Manager" required>
    </div>
    <button type="submit" name="add_role" class="btn btn-primary">Add Role</button>
  </form>

  <h4 class="mt-5">Existing Roles</h4>
  <table class="table table-bordered table-striped bg-white">
    <thead>
      <tr>
        <th>#</th>
        <th>Role Name</th>
        <th>Actions</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($roles as $index => $role): ?>
        <tr>
          <td><?= $index + 1 ?></td>
          <td>
            <form method="POST" class="d-flex gap-2 align-items-center">
              <input type="hidden" name="role_id" value="<?= $role['id'] ?>">
              <input type="text" name="updated_name" value="<?= htmlspecialchars($role['name']) ?>" class="form-control form-control-sm">
              <button type="submit" name="update_role" class="btn btn-sm btn-success">Update</button>
            </form>
          </td>
          <td>
            <a href="?delete=<?= $role['id'] ?>" onclick="return confirm('Are you sure?')" class="btn btn-sm btn-danger">Delete</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
