<?php
require_once '../../includes/db.php';

$limit = 10;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $limit;

// Get total applications
$totalStmt = $pdo->query("SELECT COUNT(*) FROM applications");
$totalRows = $totalStmt->fetchColumn();
$totalPages = ceil($totalRows / $limit);

// Get paginated applications with celebrity names
$stmt = $pdo->prepare("SELECT a.*, c.name AS celebrity FROM applications a JOIN celebrities c ON a.celebrity_id = c.id ORDER BY a.id DESC LIMIT $limit OFFSET $offset");
$stmt->execute();
$applicants = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Set active page for nav highlight (if your navbar uses this)
$activePage = 'dashboard';
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Admin Dashboard</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    body {
      background: #f1f3f7;
      min-height: 100vh;
      margin: 0;
      padding: 0;
      font-family: system-ui, sans-serif;
    }
    .content {
      margin-left: 260px;
      padding: 30px;
    }
    .table-responsive {
      overflow-x: auto;
    }
    @media (max-width: 991.98px) {
      .content {
        margin-left: 0;
        padding: 20px 15px;
        padding-top: 70px; /* space for mobile navbar */
      }
    }
  </style>
</head>
<body>

<?php include 'navbar.php'; ?>

<div class="content" role="main">
  <h2 class="mb-4">Job Applications</h2>

  <div class="table-responsive">
    <table class="table table-bordered table-striped align-middle">
      <thead class="table-dark">
        <tr>
          <th>Celebrity</th>
          <th>Full Name</th>
          <th>Email</th>
          <th>Phone</th>
          <th>Role</th>
          <th>Status</th>
          <th>Details</th>
          <th>Send Email</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($applicants as $app): ?>
          <tr>
            <td><?= htmlspecialchars($app['celebrity']) ?></td>
            <td><?= htmlspecialchars($app['full_name']) ?></td>
            <td><?= htmlspecialchars($app['email']) ?></td>
            <td><?= htmlspecialchars($app['phone']) ?></td>
            <td><?= htmlspecialchars($app['role']) ?></td>
            <td>
              <span class="badge bg-<?=
                $app['status'] === 'pending' ? 'warning' :
                ($app['status'] === 'approved' ? 'success' : 'danger')
              ?>">
                <?= ucfirst($app['status']) ?>
              </span>
            </td>
            <td>
              <a href="view_application.php?id=<?= $app['id'] ?>" class="btn btn-sm btn-info">View</a>
            </td>
            <td>
              <a href="send_email.php?id=<?= $app['id'] ?>" class="btn btn-sm btn-primary">
                Send Email
              </a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <!-- Pagination -->
  <nav aria-label="Page navigation">
    <ul class="pagination justify-content-center mt-4">
      <?php for ($i = 1; $i <= $totalPages; $i++): ?>
        <li class="page-item <?= ($page == $i) ? 'active' : '' ?>">
          <a class="page-link" href="?page=<?= $i ?>"><?= $i ?></a>
        </li>
      <?php endfor; ?>
    </ul>
  </nav>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
