<?php
require_once '../../includes/db.php';

$message = '';
if (isset($_GET['msg'])) {
    $msg = $_GET['msg'];
    if ($msg === 'deleted') {
        $message = "<div class='alert alert-success'>Celebrity deleted successfully.</div>";
    } elseif ($msg === 'updated') {
        $message = "<div class='alert alert-success'>Celebrity updated successfully.</div>";
    } elseif ($msg === 'added') {
        $message = "<div class='alert alert-success'>Celebrity added successfully.</div>";
    } elseif ($msg === 'error') {
        $message = "<div class='alert alert-danger'>An error occurred.</div>";
    }
}

$stmt = $pdo->query("SELECT * FROM celebrities ORDER BY id DESC");
$celebrities = $stmt->fetchAll();

// Set active page for nav highlighting
$activePage = 'dashboard'; // or 'list_celebrity' if you want, adjust nav.php accordingly
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Celebrity List</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    body {
      background: #f1f3f7;
      min-height: 100vh;
      margin: 0;
      padding: 0;
      font-family: system-ui, sans-serif;
    }
    .content {
      margin-left: 260px; /* leave space for sidebar */
      padding: 30px;
      max-width: 1000px;
    }
    img.celeb-photo {
      max-width: 80px;
      max-height: 80px;
      object-fit: cover;
      border-radius: 8px;
    }

    @media (max-width: 991.98px) {
      .content {
        margin-left: 0;
        padding: 20px 15px;
        padding-top: 70px; /* space for mobile navbar */
      }
    }
  </style>
</head>
<body>

<?php include 'navbar.php'; ?>

<div class="content" role="main">
  <h2>Celebrity List</h2>
  <?= $message ?>

  <?php if (count($celebrities) === 0): ?>
    <p>No celebrities found.</p>
  <?php else: ?>
    <table class="table table-bordered table-striped bg-white shadow-sm">
      <thead class="table-dark">
        <tr>
          <th>ID</th>
          <th>Name</th>
          <th>Slug</th>
          <th>Photo</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($celebrities as $celeb): ?>
          <tr>
            <td><?= htmlspecialchars($celeb['id']) ?></td>
            <td><?= htmlspecialchars($celeb['name']) ?></td>
            <td><?= htmlspecialchars($celeb['slug']) ?></td>
            <td>
              <?php if (!empty($celeb['photo'])): ?>
                <img src="../images/<?= htmlspecialchars($celeb['photo']) ?>" alt="<?= htmlspecialchars($celeb['name']) ?>" class="celeb-photo" />
              <?php endif; ?>
            </td>
            <td>
              <a href="edit_celebrity.php?id=<?= $celeb['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
              <a href="delete_celebrity.php?id=<?= $celeb['id'] ?>" 
                 class="btn btn-sm btn-danger" 
                 onclick="return confirm('Are you sure you want to delete this celebrity?');">Delete</a>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
