<?php
// nav.php - reusable navigation

if (!isset($activePage)) {
    $activePage = '';
}
?>

<style>
  /* Sidebar styles for desktop */
  .sidebar {
    height: 100vh;
    position: fixed;
    width: 250px;
    background-color: #212529;
    padding-top: 20px;
    display: flex;
    flex-direction: column;
    align-items: center;
    transition: transform 0.3s ease;
  }
  .sidebar h4 {
    color: #fff;
    margin-bottom: 2rem;
    user-select: none;
  }
  .sidebar a {
    color: #fff;
    text-decoration: none;
    display: block;
    width: 100%;
    padding: 15px 30px;
    transition: background-color 0.2s ease;
  }
  .sidebar a:hover,
  .sidebar a:focus {
    background-color: #343a40;
    outline: none;
  }
  .sidebar a.active {
    background-color: #495057;
    font-weight: bold;
  }

  /* Mobile navbar */
  .mobile-navbar {
    display: none;
    background-color: #212529;
    padding: 10px 15px;
    color: white;
    align-items: center;
    justify-content: space-between;
  }
  .mobile-navbar h4 {
    margin: 0;
    font-size: 1.25rem;
    user-select: none;
  }
  .mobile-navbar button {
    background: none;
    border: none;
    color: white;
    font-size: 1.5rem;
  }

  /* Show mobile navbar on small screens */
  @media (max-width: 991.98px) {
    .mobile-navbar {
      display: flex;
      position: fixed;
      width: 100%;
      top: 0;
      left: 0;
      z-index: 1050;
    }
  }

  /* Mobile menu (hidden by default) */
  .mobile-menu {
    display: none;
    background-color: #212529;
    position: fixed;
    top: 50px;
    left: 0;
    width: 100%;
    z-index: 1040;
    flex-direction: column;
  }
  .mobile-menu a {
    color: white;
    padding: 15px 20px;
    border-top: 1px solid #343a40;
    text-decoration: none;
  }
  .mobile-menu a:hover,
  .mobile-menu a:focus {
    background-color: #343a40;
    outline: none;
  }

  /* Show mobile menu when active */
  .mobile-menu.show {
    display: flex;
  }
</style>

<!-- Mobile Navbar -->
<div class="mobile-navbar d-lg-none" role="banner">
  <h4>Admin Panel</h4>
  <button id="mobile-menu-toggle" aria-label="Toggle menu">&#9776;</button>
</div>

<!-- Mobile Menu -->
<nav id="mobile-menu" class="mobile-menu d-lg-none" aria-label="Mobile navigation">
  <a href="index.php" class="<?= $activePage === 'dashboard' ? 'active' : '' ?>">Dashboard</a>
    <a href="send_email.php.php" class="<?= $activePage === 'payroll' ? 'active' : '' ?>">Send Email</a>
  <a href="add_celebrity.php" class="<?= $activePage === 'add_celebrity' ? 'active' : '' ?>">Add Celebrity</a>
  <a href="add_role.php" class="<?= $activePage === 'add_celebrity' ? 'active' : '' ?>">Add Role</a>
  <a href="list_celebrity.php" class="<?= $activePage === 'list_celebrity' ? 'active' : '' ?>">List Celebrity</a>
  <a href="view_payroll.php" class="<?= $activePage === 'payroll' ? 'active' : '' ?>">View Payroll</a>
</nav>

<!-- Sidebar for desktop -->
<div class="sidebar d-none d-lg-flex" role="navigation" aria-label="Sidebar navigation">
  <h4>Admin Panel</h4>
  <a href="index.php" class="<?= $activePage === 'dashboard' ? 'active' : '' ?>">Dashboard</a>
   <a href="send_email.php" class="<?= $activePage === 'dashboard' ? 'active' : '' ?>">Send Email</a>
  <a href="add_celebrity.php" class="<?= $activePage === 'add_celebrity' ? 'active' : '' ?>">Add Celebrity</a>
    <a href="add_role.php" class="<?= $activePage === 'add_celebrity' ? 'active' : '' ?>">Add Role</a>
   <a href="list_celebrity.php" class="<?= $activePage === 'list_celebrity' ? 'active' : '' ?>">List Celebrity</a>
  <a href="view_payroll.php" class="<?= $activePage === 'payroll' ? 'active' : '' ?>">View Payroll</a>
</div>

<script>
  // Mobile menu toggle
  const toggleBtn = document.getElementById('mobile-menu-toggle');
  const mobileMenu = document.getElementById('mobile-menu');

  toggleBtn.addEventListener('click', () => {
    mobileMenu.classList.toggle('show');
  });
</script>
