<?php
require_once '../../includes/db.php';

// Fetch all payroll records with applicant info
$query = "SELECT id, full_name, email, account_info, payment_method FROM applications ORDER BY id DESC";
$stmt = $pdo->query($query);
$payrolls = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Payroll Records</title>
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    body {
      background: #f0f2f5;
      padding-top: 70px;
      font-family: 'Segoe UI', sans-serif;
    }
    .container {
      background: #fff;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0,0,0,0.05);
    }
    h2 {
      text-align: center;
      margin-bottom: 25px;
      font-size: 1.8rem;
    }
    .table thead {
      background-color: #343a40;
      color: white;
    }
    .token-cell {
      font-family: monospace;
      font-size: 0.9rem;
      color: #444;
      word-break: break-word;
      max-width: 250px;
    }
    @media screen and (max-width: 576px) {
      h2 {
        font-size: 1.4rem;
      }
      .table th,
      .table td {
        font-size: 0.85rem;
        padding: 0.4rem;
      }
    }
  </style>
</head>
<body>

<?php include 'navbar.php'; ?>

<div class="container mt-4">
  <h2>Payroll Submissions</h2>
  <div class="table-responsive">
    <table class="table table-bordered table-hover align-middle">
      <thead>
        <tr>
          <th>#</th>
          <th>Applicant Name</th>
          <th>Email</th>
          <th>Account Info</th>
          <th>Payment Method</th>
        </tr>
      </thead>
      <tbody>
        <?php if (empty($payrolls)): ?>
          <tr>
            <td colspan="5" class="text-center">No payroll records found.</td>
          </tr>
        <?php else: ?>
          <?php foreach ($payrolls as $row): ?>
            <tr>
              <td><?= htmlspecialchars($row['id']) ?></td>
              <td><?= htmlspecialchars($row['full_name']) ?></td>
              <td><?= htmlspecialchars($row['email']) ?></td>
              <td><?= htmlspecialchars($row['account_info']) ?></td>
              <td><?= htmlspecialchars($row['payment_method']) ?></td>
            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
