<?php
require_once '../../includes/db.php';
require_once '../../includes/functions.php';

$slug = $_GET['name'] ?? '';
$stmt = $pdo->prepare("SELECT * FROM celebrities WHERE slug = ?");
$stmt->execute([$slug]);
$celeb = $stmt->fetch();
if (!$celeb) die("Celebrity not found.");

// Fetch roles from DB
$roles = $pdo->query("SELECT id, name FROM roles ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Apply with <?= htmlspecialchars($celeb['name']) ?> | StarApply</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="../assets/style.css">
</head>
<body>

<?php include '../../includes/navbar.php'; ?>

<!-- Hero -->
<section class="hero" style="background-image: url('../images/<?= htmlspecialchars($celeb['photo']) ?>'); background-size: cover; background-position: center;">
  <div class="container text-center">
    <h1 class="text-white">Join <?= htmlspecialchars($celeb['slug']) ?>’s Team</h1>
    <p>Apply for creative, support, or security roles with <?= $celeb['name'] ?>.</p>
  </div>
</section>

<!-- Application Form -->
<section class="py-5 bg-dark text-light">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-8">

        <form action="submit_application.php" method="POST" enctype="multipart/form-data">
          <input type="hidden" name="celebrity_id" value="<?= $celeb['id'] ?>">

          <div class="mb-3">
            <label class="form-label">Full Name</label>
            <input type="text" name="full_name" class="form-control" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Email</label>
            <input type="email" name="email" class="form-control" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Phone</label>
            <input type="text" name="phone" class="form-control" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Role Applying For</label>
            <select name="role" class="form-select" required>
              <option value="">-- Select Role --</option>
              <?php foreach ($roles as $role): ?>
                <option value="<?= htmlspecialchars($role['name']) ?>"><?= htmlspecialchars($role['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>

          <div class="mb-3">
            <label class="form-label">Short Bio</label>
            <textarea name="bio" rows="3" class="form-control" required></textarea>
          </div>

          <div class="mb-3">
            <label class="form-label">Location</label>
            <input type="text" name="location" class="form-control" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Date of Birth</label>
            <input type="date" name="dob" class="form-control" required>
          </div>

          <div class="mb-3">
            <label class="form-label">Medical Condition (if any)</label>
            <input type="text" name="condition" class="form-control">
          </div>

          <div class="mb-3">
            <label class="form-label">Work Experience</label>
            <textarea name="experience" rows="3" class="form-control"></textarea>
          </div>

          <div class="mb-3">
            <label class="form-label">Why Do You Want This Job?</label>
            <textarea name="why" rows="3" class="form-control" required></textarea>
          </div>

          <div class="mb-3">
            <label class="form-label">Upload ID Card (JPG, PNG, PDF)</label>
            <input type="file" name="idcard" accept=".jpg,.jpeg,.png,.pdf" class="form-control" required>
          </div>

          <div class="text-center mt-4">
            <button type="submit" class="btn btn-warning text-dark px-5">Submit Application</button>
          </div>

        </form>

      </div>
    </div>
  </div>
</section>

<!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '7e74f971841b071ec6dc251db0a4d37147d2f8d0';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href="https://www.smartsupp.com" target="_blank">Smartsupp</a></noscript>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
