<?php
require_once '../includes/db.php';
require_once '../includes/functions.php';
$celebrities = getCelebrityList($pdo);

// Handle search query
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
if ($search !== '') {
    $stmt = $pdo->prepare("SELECT * FROM celebrities WHERE name LIKE ?");
    $stmt->execute(["%$search%"]);
} else {
    $stmt = $pdo->query("SELECT * FROM celebrities");
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Apply to Join a Celebrity Team</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="assets/style.css">
</head>
<body>

<!-- Navbar -->
<?php include '../includes/navbar.php'; ?>

<!-- Hero Section -->
<div id="heroCarousel" class="carousel slide hero" data-bs-ride="carousel" data-bs-interval="5000">
  <div class="carousel-inner">
    <?php
    $sliderPath = __DIR__ . '/slider';
    $images = glob($sliderPath . '/*.{jpg,jpeg,png,gif,webp}', GLOB_BRACE);
    $first = true;

    foreach ($images as $imagePath):
        $filename = basename($imagePath);
    ?>
      <div class="carousel-item <?= $first ? 'active' : '' ?>">
        <img src="slider/<?= $filename ?>" class="d-block w-100" alt="Slider Image">
      </div>
    <?php
      $first = false;
    endforeach;
    ?>
  </div>
  <div class="carousel-caption">
    <h1>Work With the Stars</h1>
    <p>Exclusive roles in creative, security, and support teams.</p>
    <a href="#celebrities" class="btn">Choose a Celebrity to Apply With</a>
  </div>
</div>

<!-- Search Form -->
<div class="container mb-5 mt-4">
  <form method="GET" action="#celebrities" class="d-flex justify-content-center">
    <input
      type="text"
      name="search"
      class="form-control w-50 me-2"
      placeholder="Search for a celebrity..."
      value="<?= htmlspecialchars($search) ?>"
    />
    <button class="btn btn-warning fw-bold" type="submit">Search</button>
  </form>
</div>

<!-- How It Works -->
<section class="how-it-works">
  <div class="container">
    <h3 class="mb-4">How It Works</h3>
    <div class="row">
      <div class="col-md-4">
        <h5>1. Select a Celebrity</h5>
      </div>
      <div class="col-md-4">
        <h5>2. Submit Application</h5>
      </div>
      <div class="col-md-4">
        <h5>3. Get Updates</h5>
      </div>
    </div>
  </div>
</section>

<!-- Featured Celebrities -->
<section id="celebrities" class="celeb-grid">
  <div class="container">
    <div class="row">
      <?php if ($stmt->rowCount() === 0): ?>
        <div class="col-12 text-center text-muted">
          <p>No celebrities found matching <strong><?= htmlspecialchars($search) ?></strong>.</p>
        </div>
      <?php endif; ?>
      <?php while ($celeb = $stmt->fetch()): ?>
        <div class="col-md-3 mb-4">
          <div class="celeb-card">
            <img src="images/<?= htmlspecialchars($celeb['photo'] ?? 'default.jpg') ?>" alt="<?= $celeb['name'] ?>">
            <div class="p-3">
              <h5><?= $celeb['name'] ?></h5>
              <a href="apply/celebrity.php?name=<?= $celeb['slug'] ?>" class="btn btn-sm">Apply Now</a>
            </div>
          </div>
        </div>
      <?php endwhile; ?>
    </div>
  </div>
</section>

<!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '7e74f971841b071ec6dc251db0a4d37147d2f8d0';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href="https://www.smartsupp.com" target="_blank">Smartsupp</a></noscript>

<!-- Footer -->
<footer>
  <p>&copy; <?= date("Y") ?> StarApply. All rights reserved.</p>
  <div>
    <a href="#">Terms</a> | <a href="#">Privacy</a> | <a href="#">Contact</a>
  </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
