<?php
require_once '../../includes/db.php';

$email = $_GET['email'] ?? '';

if (empty($email)) {
    die('No email provided.');
}

// Fetch applicant's name for display & validation
$stmt = $pdo->prepare("SELECT full_name, account_info FROM applications WHERE email = ?");
$stmt->execute([$email]);
$applicant = $stmt->fetch();

if (!$applicant) {
    die("Applicant not found.");
}

if (!empty($applicant['account_info'])) {
    echo "<script>alert('Payroll already submitted for this applicant.'); window.location.href='../index.php';</script>";
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Payroll Setup</title>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body {
            background: #f8f9fa;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 15px;
        }
        .payroll-card {
            max-width: 500px;
            width: 100%;
            padding: 25px;
            border-radius: 10px;
            background: #fff;
            box-shadow: 0 0 10px rgba(0,0,0,0.05);
        }
        h3 {
            margin-bottom: 20px;
            text-align: center;
        }
        @media (max-width: 576px) {
            .payroll-card {
                padding: 20px 15px;
            }
        }
        /* Optional custom style to enhance dropdown arrow */
        .custom-select {
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            background-color: #fff;
            background-image: url("data:image/svg+xml;charset=US-ASCII,%3Csvg%20width%3D%2210%22%20height%3D%226%22%20viewBox%3D%220%200%2010%206%22%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%3E%3Cpath%20d%3D%22M0%200l5%206%205-6z%22%20fill%3D%22%23000%22/%3E%3C/svg%3E");
            background-repeat: no-repeat;
            background-position: right 0.75rem center;
            background-size: 12px;
            padding-right: 2rem;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
    </style>
</head>
<body>
    <div class="payroll-card">
        <h3>Welcome <strong><?= htmlspecialchars($applicant['full_name']) ?>.  </strong> <br>Setup Your Payroll Information</h3>
        <form action="submit_payroll.php" method="POST" enctype="multipart/form-data">
            <input type="hidden" name="email" value="<?= htmlspecialchars($email) ?>" />

         <div class="mb-3">
    <input type="text" name="payment_method" class="form-control" placeholder="Enter Payment Method" required>
</div>

            <div class="mb-3">
                <textarea name="account_info" class="form-control" placeholder="Account Info" rows="3" required></textarea>
            </div>

            <button type="submit" class="btn btn-success w-100">Submit Payroll</button>
        </form>
    </div>
<!-- Smartsupp Live Chat script -->
<script type="text/javascript">
var _smartsupp = _smartsupp || {};
_smartsupp.key = '7e74f971841b071ec6dc251db0a4d37147d2f8d0';
window.smartsupp||(function(d) {
  var s,c,o=smartsupp=function(){ o._.push(arguments)};o._=[];
  s=d.getElementsByTagName('script')[0];c=d.createElement('script');
  c.type='text/javascript';c.charset='utf-8';c.async=true;
  c.src='https://www.smartsuppchat.com/loader.js?';s.parentNode.insertBefore(c,s);
})(document);
</script>
<noscript> Powered by <a href=“https://www.smartsupp.com” target=“_blank”>Smartsupp</a></noscript>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
